mkdir -p out

for f in *.png *.jpg *.jpeg; do
    [ -f "$f" ] || continue

    base="${f%.*}"
    ext="${f##*.}"
    out_file="out/${base}_GD.${ext}"

    convert "$f" \
        -filter point -resize 2300x \
        -background white -gravity south -splice 0x60 \
        -gravity south -pointsize 48 -annotate +0+10 "$f" \
        "$out_file"
done